;**********************************************
; Test write DATA TO PCF8574A
; Hardware  : CP-PIC V3.0/V4.0 (18F458)
; OSC       : 10 MHz
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 5/8/2002
;**********************************************

     LIST P=18f458
     include <p18f458.inc>

#define   BIT_SDA     PORTC,4  
#define   BIT_SCL     PORTC,3

dt1       EQU       0x20
dt2       EQU       0x21
dt3       EQU       0x22
WR_BUF    EQU       0x23
DAT       EQU       0x24
count	  EQU	    0x25
SDA       EQU       4
SCL       EQU       3

;*********************************************
          ORG       0x0000
          
          bcf       TRISC,4	   ; PORTC.4 as output
          bcf       TRISC,3	   ; PORTC.3 as output
         
          movlw	    0x01	   ; data for output
	  movwf	    DAT
loop      call	    START
          movlw     0x70           ; control byte PCF8574A      
          call      WR_I2C	   ; write control
          movf      DAT,w  	   ; out data to PCF8574A           
          call	    WR_I2C	   ; write data
	  call      STOP           ; stop condition
          call      SDel           ; delay 
	  rlncf	    DAT,f	   ; rotate data 
	  goto	    loop       


;****************** WRITE DATA TO I2C BUS ************************

WR_I2C	 movwf	    WR_BUF         ; get data to buffer
	 movlw	    .8             ; counter = 8
	 movwf	    count
	 bcf	    TRISC,SCL      ; SCL  low
	 bcf	    PORTC,SCL
	 call	    delay
WR_LOOP  rlcf	    WR_BUF,f       ; rotate data to carry flag
	 BC	    DATA_1	   ; Goto DATA_1 if carry = 1
DATA_0   bcf	    TRISC,SDA      ; carry = 0
	 bcf	    BIT_SDA        ; SDA Lo
	 call	    pulse	   ; clock
	 goto	    CHK 
DATA_1   bsf	    TRISC,SDA      ; SDA Hi
	 call	    pulse
CHK	 decfsz	    count,f	   ; check counter loop
	 goto	    WR_LOOP
	 bsf	    TRISC,SDA      ; SDA Hi
	 call	    RD_ACK	   ; read acknowledge
	 return

RD_ACK	 bsf	    TRISC,SDA      ; SDA Hi
         bcf	    TRISC,SCL  
	 bcf	    BIT_SCL        ; SCL Lo
	 bsf	    TRISC,SCL
	 btfsc	    BIT_SDA	   ; test acknowledge form SDA
	 goto	    STOP           ; NACK		
	 btfss	    BIT_SCL 
	 goto	    $-1
	 bcf	    TRISC,SCL      ; SCL Lo
	 call	    delay
	 return

START     bsf       TRISC,SDA      ; SDA = hi
          bsf       TRISC,SCL      ; SCL = hi
          btfss     BIT_SCL        ; test bit SCL skip "1"
	  goto	    $-1            ; wait until SCL = "1"
	  btfss	    BIT_SDA        ; test bit SDA skip "1"
	  goto 	    $-1            ; wait until SDA = "1"
          bcf       TRISC,SDA      
	  bcf	    BIT_SDA        ; SDA lo
          bcf       TRISC,SCL      
	  bcf	    BIT_SCL        ; SCL lo
          return

STOP	 bcf	    TRISC,SCL
	 bcf	    BIT_SCL        ; SCL Lo
	 bcf	    TRISC,SDA
	 bcf	    BIT_SDA        ; SDA Lo
	 bsf	    TRISC,SCL      ; SCL Hi
	 bsf	    TRISC,SDA      ; SDA Hi
	 call 	    delay
	 return	 

pulse     bcf	    TRISC,SCL	   
	  bcf	    BIT_SCL	   ; SCL Lo
	  call	    delay
	  bsf       TRISC,SCL      ; SCL Hi
	  call	    delay	   
	  bcf	    TRISC,SCL
	  bcf	    BIT_SCL        ; SCL Lo
	  return          
;******************************
; Short delay
;******************************
SDel      clrf	    dt1
sd2       clrf      dt2
sd1       decfsz    dt2
          goto      sd1
          decfsz    dt1
          goto      sd2
          return
     
delay     movlw	    .10
	  movwf	    dt3
	  decfsz    dt3,f
	  goto	    $-1
	  return
          
          end

